---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-カスタムルート一覧（Custom Routes）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. 全項目が根拠付きのため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/build/utils.ts` 行645-649（printCustomRoutes関数シグネチャ）
- E-02: `packages/next/src/build/utils.ts` 行650-698（printRoutes内部関数）
- E-03: `packages/next/src/build/utils.ts` 行702-704（Redirects表示条件）
- E-04: `packages/next/src/build/utils.ts` 行705-707（Headers表示条件）
- E-05: `packages/next/src/build/utils.ts` 行709-716（Rewrites統合・表示条件）
- E-06: `packages/next/src/build/utils.ts` 行665-679（ルート文字列生成）
- E-07: `packages/next/src/build/utils.ts` 行682-692（ヘッダー表示）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | printCustomRoutes関数がメイン処理 | E-01 | ○ |
| C-02 | 表示順はRedirects → Headers → Rewrites | E-03, E-04, E-05 | ○ |
| C-03 | Redirectsが空でない場合のみ表示 | E-03 | ○ |
| C-04 | Headersが空でない場合のみ表示 | E-04 | ○ |
| C-05 | Rewritesは3種類を統合 | E-05 | ○ |
| C-06 | sourceを┌で表示 | E-06（行665） | ○ |
| C-07 | statusCode設定時はstatusを表示、なければpermanent | E-06（行673-679） | ○ |
| C-08 | ヘッダーの最終項目は└、それ以外は├ | E-07（行690） | ○ |
| C-09 | Redirectsのdestinationは├で表示 | E-06（行669） | ○ |
| C-10 | Rewritesのdestinationは└で表示 | E-06（行669:isRedirects判定） | ○ |
| C-11 | 種別名は下線付き表示 | E-02（行656） | ○ |
| C-12 | printはconsole.logのエイリアス | `packages/next/src/build/utils.ts` 行136 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Redirectsのstatus/permanent表示条件が正確か確認
- [ ] Rewritesの3種類統合（beforeFiles, afterFiles, fallback）が正しいか確認
- [ ] ヘッダー表示のツリー罫線が正確か確認
